/**
 * CacheButton class
 * 
 * @package FASTCACHE::plugins::system
 * @author Host.it
 * @copyright (C) 2023 Host.it
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
//'use strict';
addEventListener("DOMContentLoaded", (event) => {
	// Get the current URL
	let currentURL = window.location.href;
	if(currentURL.indexOf('fastcacheglobaltask') == -1) {
		if(currentURL.indexOf('?') > -1) {
			currentURL += '&fastcacheglobaltask=clearglobalcache';
		} else {
			currentURL += '?fastcacheglobaltask=clearglobalcache';
		}
	}
	
	let fastcacheClearCacheBtnSnippet = `<div class="header-item">
										<a href="${currentURL}" title="Clear Fastcache Cache" class="header-item-content">
                                    	    <div class="header-item-icon">
												<span class="icon-trash" aria-hidden="true"></span>
											</div>
											<div class="header-item-text">Fastcache cache</div>
										</a>
									  </div>`;
	let fragment = document.createRange().createContextualFragment(fastcacheClearCacheBtnSnippet);
	let headerItems = document.querySelector('div.header-items')
	if(headerItems) {
		headerItems.appendChild(fragment);
	}
});