jQuery(function($) {
	var timestamp = new Date().getTime();
	
	var datas = [];
	// Get all the multiple select fields and iterate through each
	$('select[multiple=multiple]').each(function(){
		var el = $(this);

		datas.push({'id': el.attr('id'),'type':el.attr('data-paramtype'), 'param': el.attr('data-paramname'), 'group': el.attr('data-filegroup')});

	});

	var xhr = jQuery.ajax({
		dataType: 'json',
		url: ajaxEndpoint + "&task=exclusionfiles&time=" + timestamp,
		data: {'data': datas},
		method: 'POST',
		timeout: 30000,
		success: function (response) {
			$.each(response.data, function(id, obj){
				$.each(obj.data, function(value, option){
					$('#' + id).append('<option value="' + value + '">' + option + '</option>');
				});
			
				$('#' + id).removeAttr('disabled');
				
				$('#' + id).prev('img.dropdown-loading').remove();
				
				$('#' + id).select2({
				    tags: true,
				    tokenSeparators: [',']
				});
			});
		},
		error: function (jqXHR, textStatus, errorThrown) {
			console.error('Error returned from ajax function \'getmultiselect\'');
			console.error('textStatus: ' + textStatus);
			console.error('errorThrown: ' + errorThrown);
			
			$('img.dropdown-loading').remove();
			$('select.select2-dropdown').select2({
			    tags: true,
			    tokenSeparators: [',']
			});
		}

	});
	
	$.fn.unchosen = function() {
		return $(this).each(function() {
			var element = $(this);
			if(element.hasClass('select2-dropdown')){
				element.next('[id*=_chzn]').remove();
			}
		});
	}
	
	setTimeout(function(){
		$(document).find("select.select2-dropdown").unchosen();
	}, 100)
	
	
	$('#jform_params_img_processing_srcset_datasrc1').on('click', function(){
		var currentValue = parseInt($(this).val());
		if(currentValue == 1) {
			$('#jform_params_img_processing_datasrc1').trigger('click');
		}
	});
	
	// Append task buttons to the toolbar if the plugin is enabled
	let isPluginEnabled = !!parseInt($('#jform_enabled').val());
	if(isPluginEnabled) {
		$('#toolbar-cancel').after(`
				<joomla-toolbar-button>
				<a class="btn btn-sm btn-primary btn-fastcache hasTooltip" href="${jSpeedClearCacheURL}" title="${PLG_FASTCACHE_CLEAR_CACHE_DESC}">
				<span class="icon-cancel" aria-hidden="true"></span>
				${PLG_FASTCACHE_CLEAR_CACHE}
				</a>
		</joomla-toolbar-button>`);
		
		$('#toolbar-cancel').after(`
				<joomla-toolbar-button>
				<a class="btn btn-sm btn-primary btn-fastcache hasTooltip" href="${jSpeedRestoreHtaccessURL}" title="${PLG_FASTCACHE_HTACCESS_RESTORE_DESC}">
				<span class="icon-refresh" aria-hidden="true"></span>
				${PLG_FASTCACHE_HTACCESS_RESTORE}
				</a>
		</joomla-toolbar-button>`);
		
		$('#toolbar-cancel').after(`
				<joomla-toolbar-button>
				<a class="btn btn-sm btn-primary btn-fastcache hasTooltip" href="${jSpeedOptimizeHtaccessURL}" title="${PLG_FASTCACHE_HTACCESS_SETUP_DESC}">
				<span class="icon-pencil" aria-hidden="true"></span>
				${PLG_FASTCACHE_HTACCESS_SETUP}
				</a>
		</joomla-toolbar-button>`);
		
		[].slice.call(document.querySelectorAll('a.btn.hasTooltip')).map(function (tooltipEl) {
			let tooltipInstance = new bootstrap.Tooltip(tooltipEl,{
				trigger:'hover', 
				html: true,
				placement: 'bottom',
				container: 'body'
			});
			return tooltipInstance;
		});
		
		[].slice.call(document.querySelectorAll('span.badge.hasPopover')).map(function (popoverEl) {
			let popoverInstance = new bootstrap.Popover(popoverEl,{
				trigger:'hover', 
				html: true,
				placement: 'bottom',
				container: 'body'
			});
			return popoverInstance;
		});
	}
	
	(function () {
	  function flip() {
	    var el = document.getElementById('myTab');
	    if (!el) return false;

	    el.setAttribute('orientation', 'vertical'); 
	    return true;
	  }

	  flip();
	})();
	
	// Il pulsante "Plugin" (primo tab) non ha icona perché gestito dal core Joomla
	// Aggiungiamo manualmente l'icona per coerenza visiva con gli altri tab
	(function() {
		// Aspetta che il DOM sia completamente caricato
		setTimeout(function() {
			// Trova il pulsante Plugin tramite aria-controls
			var pluginButton = document.querySelector('button[aria-controls="general"]');
			
			if (pluginButton) {
				if (!pluginButton.querySelector('.fastcache-icon-plugin')) {
					// Crea l'elemento icona
					var iconSpan = document.createElement('span');
					iconSpan.className = 'fastcache-icon-plugin';
					iconSpan.setAttribute('aria-hidden', 'true');
					
					// Inserisci l'icona PRIMA del testo
					pluginButton.prepend(iconSpan);
				}
			}
		}, 100);
	})();
	
	// Handle htaccess_cache_enable switcher - write/remove page cache rules
	(function() {
		// Get the switcher elements for htaccess_cache_enable
		// ID0 = value 0 = NO/OFF
		// ID1 = value 1 = YES/ON
		var $switcherOff = $('#jform_params_htaccess_cache_enable0'); // NO (value=0)
		var $switcherOn = $('#jform_params_htaccess_cache_enable1');  // YES (value=1)
		
		if (!$switcherOn.length || !$switcherOff.length) {
			return; // Switcher not found, exit
		}
		
		// Function to call the task via AJAX
		function callPageCacheTask(task, actionText) {
			// Show loading message
			
			// Build the URL with the task and format=json
			var baseUrl = window.location.href.split('&fastcachetask=')[0].split('&fastcacheformat=')[0];
			var taskUrl = baseUrl + '&fastcachetask=' + task + '&fastcacheformat=json';
			
			// Show loading indicator
			$('body').append('<div id="fastcache-loading" style="position:fixed;top:50%;left:50%;transform:translate(-50%,-50%);background:rgba(0,0,0,0.8);color:white;padding:20px;border-radius:5px;z-index:9999;"><span class="icon-loop" style="animation:spin 1s linear infinite;display:inline-block;"></span> ' + actionText + ' page cache rules...</div>');
			
			// Add CSS animation if not present
			if (!$('#fastcache-spin-style').length) {
				$('head').append('<style id="fastcache-spin-style">@keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }</style>');
			}
			
			// Call the task via AJAX
			$.ajax({
				url: taskUrl,
				type: 'GET',
				dataType: 'json',
				timeout: 30000,
				success: function(response) {
					// Remove loading indicator
					$('#fastcache-loading').remove();
					
					// Prepare messages for Joomla's message system
					if (response.messages && response.messages.length > 0) {
						var messagesByType = {};
						
						// Group messages by type
						response.messages.forEach(function(msg) {
							var type = msg.type || 'info';
							if (!messagesByType[type]) {
								messagesByType[type] = [];
							}
							messagesByType[type].push(msg.message);
						});
						
						// Display messages using Joomla's system
						if (typeof Joomla !== 'undefined' && typeof Joomla.renderMessages === 'function') {
							Joomla.renderMessages(messagesByType);
						} else {
							// Fallback: show in alert
							var allMessages = '';
							for (var type in messagesByType) {
								allMessages += messagesByType[type].join('\n') + '\n';
							}
							if (allMessages) {
								alert(allMessages);
							}
						}
					} else {
						// No messages, show default success
						if (typeof Joomla !== 'undefined' && typeof Joomla.renderMessages === 'function') {
							Joomla.renderMessages({
								'success': ['Page cache rules ' + actionText + ' successfully']
							});
						} else {
							alert('Page cache rules ' + actionText + ' successfully');
						}
					}
					
					// Scroll to top to see message
					$('html, body').animate({ scrollTop: 0 }, 300);
				},
				error: function(jqXHR, textStatus, errorThrown) {
					// Remove loading indicator
					$('#fastcache-loading').remove();
					
					// Show error message
					if (typeof Joomla !== 'undefined' && typeof Joomla.renderMessages === 'function') {
						Joomla.renderMessages({
							'error': ['Error ' + actionText + PLG_FASTCACHE_PAGE_CACHE_RULES + textStatus]
						});
					} else {
						alert('Error ' + actionText + PLG_FASTCACHE_PAGE_CACHE_RULES + textStatus);
					}
				}
			});
		}
		
		// Track the previous state to detect actual changes
		var previousState = $switcherOn.prop('checked');
		
		// Handle clicks on the parent switcher fieldset
		// This catches clicks on both radio buttons and the visual toggle
		$('#jform_params_htaccess_cache_enable').on('click', 'input[type="radio"]', function() {
			var clickedValue = $(this).val();
			var wasOn = previousState;
			
			// Give time for the radio to update
			setTimeout(function() {
				var nowOn = $switcherOn.prop('checked');
				
				if (nowOn !== wasOn) {
					if (nowOn) {
						// Switched to ON
						previousState = true;
						callPageCacheTask('writePageCacheRules', PLG_FASTCACHE_PAGE_CACHE_RULES_ADDING);
					} else {
						// Switched to OFF
						previousState = false;
						callPageCacheTask('removePageCacheRules', PLG_FASTCACHE_PAGE_CACHE_RULES_REMOVING);
					}
				}
			}, 150);
		});
	})();
});

function FastcacheUcFirst(string) {
    return string[0].toUpperCase() + string.slice(1);
}