/**
 * Auto configuration class
 * 
 * @package FASTCACHE::plugins::system
 * @author Host.it
 * @copyright (C) 2021 Host.it
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
//'use strict';
(function($) {
	var AutoConfiguration = function() {
		/**
    	 * Register user events for interface controls
    	 * 
    	 * @access private
    	 * @param Boolean initialize
    	 * @return Void
    	 */
    	var addListeners = function(initialize) {
    		var optimizationLevelSettings = {
    				1 : {
    					'jform_params_html_minify1' : {'action' : 'click', 'target' : 'jform_params_html_minify1'},
    					'jform_params_html_minify_level' : '0',
    					'jform_params_combine_files_enable1' : {'action' : 'click', 'target' : 'jform_params_combine_files_enable1'},
    					'jform_params_css1' : {'action' : 'click', 'target' : 'jform_params_css1'},
    					'jform_params_javascript0' : {'action' : 'click', 'target' : 'jform_params_javascript0'},
    					'jform_params_font_display_swap0' : {'action' : 'click', 'target' : 'jform_params_font_display_swap0'},
    					'jform_params_css_minify0' : {'action' : 'click', 'target' : 'jform_params_css_minify0'},
    					'jform_params_js_minify0' : {'action' : 'click', 'target' : 'jform_params_js_minify0'},
    					'jform_params_defer_combined_css0' : {'action' : 'click', 'target' : 'jform_params_defer_combined_css0'},
    					'jform_params_bottom_js0' : {'action' : 'click', 'target' : 'jform_params_bottom_js0'},
    					'jform_params_load_asynchronous0' : {'action' : 'click', 'target' : 'jform_params_load_asynchronous0'},
    					'jform_params_lazyload0' : {'action' : 'click', 'target' : 'jform_params_lazyload0'},
    					'jform_params_lazyload_mode' : 'native',
    					'jform_params_lazyload_mode_speculative0' : {'action' : 'click', 'target' : 'jform_params_lazyload_mode_speculative0'},
    					'jform_params_lightimgs_status0' : {'action' : 'click', 'target' : 'jform_params_lightimgs_status0'},
						'jform_params_add_size_attributes0' : {'action' : 'click', 'target' : 'jform_params_add_size_attributes0'},
    					'jform_params_convert_all_images_to_webp0' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_webp0'},
    					'jform_params_convert_all_images_to_avif0' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_avif0'},
    					'jform_params_optimize_css_delivery_enable0' : {'action' : 'click', 'target' : 'jform_params_optimize_css_delivery_enable0'}
    				},
    				2 : {
    					'jform_params_html_minify1' : {'action' : 'click', 'target' : 'jform_params_html_minify1'},
    					'jform_params_html_minify_level' : '1',
    					'jform_params_combine_files_enable1' : {'action' : 'click', 'target' : 'jform_params_combine_files_enable1'},
    					'jform_params_css1' : {'action' : 'click', 'target' : 'jform_params_css1'},
    					'jform_params_javascript1' : {'action' : 'click', 'target' : 'jform_params_javascript1'},
    					'jform_params_font_display_swap1' : {'action' : 'click', 'target' : 'jform_params_font_display_swap1'},
    					'jform_params_css_minify0' : {'action' : 'click', 'target' : 'jform_params_css_minify0'},
    					'jform_params_js_minify0' : {'action' : 'click', 'target' : 'jform_params_js_minify0'},
    					'jform_params_defer_combined_css0' : {'action' : 'click', 'target' : 'jform_params_defer_combined_css0'},
    					'jform_params_bottom_js0' : {'action' : 'click', 'target' : 'jform_params_bottom_js0'},
    					'jform_params_load_asynchronous0' : {'action' : 'click', 'target' : 'jform_params_load_asynchronous0'},
    					'jform_params_lazyload0' : {'action' : 'click', 'target' : 'jform_params_lazyload0'},
    					'jform_params_lazyload_mode' : 'native',
    					'jform_params_lazyload_mode_speculative0' : {'action' : 'click', 'target' : 'jform_params_lazyload_mode_speculative0'},
    					'jform_params_lightimgs_status0' : {'action' : 'click', 'target' : 'jform_params_lightimgs_status0'},
						'jform_params_add_size_attributes0' : {'action' : 'click', 'target' : 'jform_params_add_size_attributes0'},
    					'jform_params_convert_all_images_to_webp0' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_webp0'},
    					'jform_params_convert_all_images_to_avif0' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_avif0'},
    					'jform_params_optimize_css_delivery_enable0' : {'action' : 'click', 'target' : 'jform_params_optimize_css_delivery_enable0'}
    				},
    				3 : {
    					'jform_params_html_minify1' : {'action' : 'click', 'target' : 'jform_params_html_minify1'},
    					'jform_params_html_minify_level' : '1',
    					'jform_params_combine_files_enable1' : {'action' : 'click', 'target' : 'jform_params_combine_files_enable1'},
    					'jform_params_css1' : {'action' : 'click', 'target' : 'jform_params_css1'},
    					'jform_params_javascript1' : {'action' : 'click', 'target' : 'jform_params_javascript1'},
    					'jform_params_font_display_swap1' : {'action' : 'click', 'target' : 'jform_params_font_display_swap1'},
    					'jform_params_css_minify1' : {'action' : 'click', 'target' : 'jform_params_css_minify1'},
    					'jform_params_js_minify1' : {'action' : 'click', 'target' : 'jform_params_js_minify1'},
    					'jform_params_defer_combined_css1' : {'action' : 'click', 'target' : 'jform_params_defer_combined_css1'},
    					'jform_params_bottom_js0' : {'action' : 'click', 'target' : 'jform_params_bottom_js0'},
    					'jform_params_load_asynchronous0' : {'action' : 'click', 'target' : 'jform_params_load_asynchronous0'},
    					'jform_params_lazyload1' : {'action' : 'click', 'target' : 'jform_params_lazyload1'},
    					'jform_params_lazyload_mode' : 'native',
    					'jform_params_lazyload_mode_speculative0' : {'action' : 'click', 'target' : 'jform_params_lazyload_mode_speculative0'},
    					'jform_params_lightimgs_status0' : {'action' : 'click', 'target' : 'jform_params_lightimgs_status0'},
						'jform_params_add_size_attributes0' : {'action' : 'click', 'target' : 'jform_params_add_size_attributes0'},
    					'jform_params_convert_all_images_to_webp0' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_webp0'},
    					'jform_params_convert_all_images_to_avif0' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_avif0'},
    					'jform_params_optimize_css_delivery_enable0' : {'action' : 'click', 'target' : 'jform_params_optimize_css_delivery_enable0'}
    				},
    				4 : {
    					'jform_params_html_minify1' : {'action' : 'click', 'target' : 'jform_params_html_minify1'},
    					'jform_params_html_minify_level' : '1',
    					'jform_params_combine_files_enable1' : {'action' : 'click', 'target' : 'jform_params_combine_files_enable1'},
    					'jform_params_css1' : {'action' : 'click', 'target' : 'jform_params_css1'},
    					'jform_params_javascript1' : {'action' : 'click', 'target' : 'jform_params_javascript1'},
    					'jform_params_font_display_swap1' : {'action' : 'click', 'target' : 'jform_params_font_display_swap1'},
    					'jform_params_css_minify1' : {'action' : 'click', 'target' : 'jform_params_css_minify1'},
    					'jform_params_js_minify1' : {'action' : 'click', 'target' : 'jform_params_js_minify1'},
    					'jform_params_defer_combined_css1' : {'action' : 'click', 'target' : 'jform_params_defer_combined_css1'},
    					'jform_params_bottom_js1' : {'action' : 'click', 'target' : 'jform_params_bottom_js1'},
    					'jform_params_load_asynchronous1' : {'action' : 'click', 'target' : 'jform_params_load_asynchronous1'},
    					'jform_params_lazyload1' : {'action' : 'click', 'target' : 'jform_params_lazyload1'},
    					'jform_params_lazyload_mode' : 'both',
    					'jform_params_lazyload_mode_speculative0' : {'action' : 'click', 'target' : 'jform_params_lazyload_mode_speculative0'},
    					'jform_params_lightimgs_status1' : {'action' : 'click', 'target' : 'jform_params_lightimgs_status1'},
						'jform_params_add_size_attributes0' : {'action' : 'click', 'target' : 'jform_params_add_size_attributes0'},
    					'jform_params_convert_all_images_to_webp1' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_webp1'},
    					'jform_params_convert_all_images_to_avif0' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_avif0'},
    					'jform_params_optimize_css_delivery_enable0' : {'action' : 'click', 'target' : 'jform_params_optimize_css_delivery_enable0'}
    				},
    				5 : {
    					'jform_params_html_minify1' : {'action' : 'click', 'target' : 'jform_params_html_minify1'},
    					'jform_params_html_minify_level' : '2',
    					'jform_params_combine_files_enable1' : {'action' : 'click', 'target' : 'jform_params_combine_files_enable1'},
    					'jform_params_css1' : {'action' : 'click', 'target' : 'jform_params_css1'},
    					'jform_params_javascript1' : {'action' : 'click', 'target' : 'jform_params_javascript1'},
    					'jform_params_font_display_swap1' : {'action' : 'click', 'target' : 'jform_params_font_display_swap1'},
    					'jform_params_css_minify1' : {'action' : 'click', 'target' : 'jform_params_css_minify1'},
    					'jform_params_js_minify1' : {'action' : 'click', 'target' : 'jform_params_js_minify1'},
    					'jform_params_defer_combined_css1' : {'action' : 'click', 'target' : 'jform_params_defer_combined_css1'},
    					'jform_params_bottom_js1' : {'action' : 'click', 'target' : 'jform_params_bottom_js1'},
    					'jform_params_load_asynchronous1' : {'action' : 'click', 'target' : 'jform_params_load_asynchronous1'},
    					'jform_params_lazyload1' : {'action' : 'click', 'target' : 'jform_params_lazyload1'},
    					'jform_params_lazyload_mode' : 'both',
    					'jform_params_lazyload_mode_speculative1' : {'action' : 'click', 'target' : 'jform_params_lazyload_mode_speculative1'},
    					'jform_params_lightimgs_status1' : {'action' : 'click', 'target' : 'jform_params_lightimgs_status1'},
						'jform_params_add_size_attributes1' : {'action' : 'click', 'target' : 'jform_params_add_size_attributes1'},
    					'jform_params_convert_all_images_to_webp1' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_webp1'},
    					'jform_params_convert_all_images_to_avif0' : {'action' : 'click', 'target' : 'jform_params_convert_all_images_to_avif0'},
    					'jform_params_optimize_css_delivery_enable1' : {'action' : 'click', 'target' : 'jform_params_optimize_css_delivery_enable1'}
    				}
    		};
    		var optimizationIconsMapping = {
    				'jform_params_html_minify1' : 'icon-contract',
    				'jform_params_html_minify_level' : 'icon-contract',
    				'jform_params_combine_files_enable0' : 'icon-box-add',
    				'jform_params_combine_files_enable1' : 'icon-box-add',
    				'jform_params_css0' : 'icon-box-add',
    				'jform_params_css1' : 'icon-box-add',
    				'jform_params_javascript0' : 'icon-box-add',
    				'jform_params_javascript1' : 'icon-box-add',
    				'jform_params_font_display_swap0' : 'icon-dashboard',
    				'jform_params_font_display_swap1' : 'icon-dashboard',
    				'jform_params_css_minify0' : 'icon-contract',
    				'jform_params_css_minify1' : 'icon-contract',
    				'jform_params_js_minify0' : 'icon-contract',
    				'jform_params_js_minify1' : 'icon-contract',
    				'jform_params_defer_combined_css0' : 'icon-unblock',
    				'jform_params_bottom_js0' : 'icon-download',
    				'jform_params_defer_combined_css1' : 'icon-unblock',
    				'jform_params_bottom_js1' : 'icon-download',
    				'jform_params_load_asynchronous0' : 'icon-unblock',
    				'jform_params_load_asynchronous1' : 'icon-unblock',
    				'jform_params_lazyload0' : 'icon-pictures',
    				'jform_params_lazyload1' : 'icon-pictures',
    				'jform_params_lightimgs_status0' : 'icon-pictures',
    				'jform_params_lightimgs_status1' : 'icon-pictures',
    				'jform_params_convert_all_images_to_webp0' : 'icon-pictures',
    				'jform_params_convert_all_images_to_webp1' : 'icon-pictures',
    				'jform_params_convert_all_images_to_avif0' : 'icon-pictures',
    				'jform_params_convert_all_images_to_avif1' : 'icon-pictures',
    				'jform_params_lazyload_mode' : 'icon-pictures',
					'jform_params_lazyload_mode_speculative0' : 'icon-shuffle',
					'jform_params_lazyload_mode_speculative1' : 'icon-shuffle',
					'jform_params_add_size_attributes0' : 'icon-plus',
					'jform_params_add_size_attributes1' : 'icon-plus',
					'jform_params_optimize_css_delivery_enable0' : 'icon-download',
					'jform_params_optimize_css_delivery_enable1' : 'icon-download'
    		};
    		var optimizationLevel = parseInt($('#jform_params_rangeslider').val());
    		$('#jform_params_rangeslider').on('change', function(jqEvent, doNotRefreshSettings){
    			optimizationLevel = $(this).val();
    			$('span.innerlabel').removeClass('auto-label-active');
    			$('span.innerlabel[data-label=' + optimizationLevel + ']').addClass('auto-label-active');
    			$('#optimizationslist').empty();
    			$.each(optimizationLevelSettings[optimizationLevel], function(control, controlValue){
    				if(typeof(controlValue) !== "object") {
    					var textOptimizationContext = $('#' + control).parents('div.control-group');
    					if(!doNotRefreshSettings) {
    						$('#' + control).val(controlValue);
    					}
    				} else {
    					var textOptimizationContext = $('label[for=' + controlValue.target + ']').parents('div.control-group');
    					if(!doNotRefreshSettings) {
    						$('label[for=' + controlValue.target + ']').trigger(controlValue.action);
    					}
    				}
    				
    				var targetControl = $('*[id="' + control + '"]');
    				var labelClass = 'bg-primary';
    				var labelIcon = '<span class="icon-info-circle"></span>';
    				if(targetControl.get(0).nodeName.toLowerCase() == 'select') {
    					var optionValue = targetControl.val();
    					var controlCalculatedValue = $('option[value=' + optionValue + ']', targetControl).text();
    				} else {
    					var controlCalculatedValue = parseInt(targetControl.val()) ? PLG_FASTCACHE_AUTO_CONFIGURATION_ENABLED : PLG_FASTCACHE_AUTO_CONFIGURATION_DISABLED;
    					labelClass = parseInt(targetControl.val()) ? 'bg-success' : 'bg-secondary';
    					labelIcon = parseInt(targetControl.val()) ? '<span class="icon-check"></span>' : '<span class="icon-remove"></span>';
    				} 
    				var textOptimizationLabel = $('div.control-label label', textOptimizationContext).text();
    				$('#optimizationslist').append(	'<div class="row pt-2 pb-2 fastcache-setting-row border-bottom">' +
    						'<div class="col col-lg-9"><span class="' + optimizationIconsMapping[control] + '" aria-hidden="true"></span>' + textOptimizationLabel + '</div>' +
    						'<div class="col col-lg-3"><span class="badge ' + labelClass + '">' + labelIcon + controlCalculatedValue + '</span></div>' +
    				'</div>');
    			});
    			
    			if(optimizationLevel == 0) {
    				$('#optimizationslist').removeClass('populated');
    			} else {
    				$('#optimizationslist').addClass('populated');
    			}
    		});
    		if(optimizationLevel > 0) {
    			$('#jform_params_rangeslider').trigger('change', [true]);
    			$('#optimizationslist').addClass('populated');
    		} else {
    			$('span.innerlabel[data-label=0]').addClass('auto-label-active');
    		}
    	};

		/**
		 * Function dummy constructor
		 * 
		 * @access private
		 * @param String
		 *            contextSelector
		 * @method <<IIFE>>
		 * @return Void
		 */
		(function __construct() {
			// Add UI events
			addListeners.call(this, true);
			
			// Auto configuration slider management
			const slider = document.getElementById("jform_params_rangeslider");
			function updateProgress() {
			  const val = slider.value * 20;
			  document.documentElement.style.setProperty("--range-progress", val + "%");
			}
			updateProgress();
			slider.addEventListener("input", updateProgress);
						
			$('#jform_params_rangeslider').removeClass('form-range');
		}).call(this);
	}
	
	//On DOM Ready
	$(function() {
		window.FastcacheAutoConfiguration = new AutoConfiguration();
	});
})(jQuery);