<?php
/**
 * Application install script
 * @author Host.it
 * @Copyright (C) 2026 - Host.it
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html    
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Installer\InstallerScriptInterface;
use Joomla\CMS\Installer\InstallerAdapter;

/** 
 * Application install script class
 */
class FastcacheBaseInstallerScript {
	/*
	* Find mimimum required joomla version for this extension. It will be read from the version attribute (install tag) in the manifest file
	*/
	private $minimum_joomla_release = '4.0';
	
	/*
	 * $parent is the class calling this method.
	 * $type is the type of change (install, update or discover_install, not uninstall).
	 * preflight runs before anything else and while the extracted files are in the uploaded temp folder.
	 * If preflight returns false, Joomla will abort the update and undo everything already done.
	 */
	function preflight(string $type, InstallerAdapter $parent): bool {
		// Check for Joomla compatibility
		if(version_compare(JVERSION, $this->minimum_joomla_release, '<')) {
			Factory::getApplication()->enqueueMessage (Text::sprintf('PLG_FASTCACHE_INSTALLING_VERSION_NOTCOMPATIBLE', JVERSION), 'error');
			
			if(version_compare(JVERSION, '3.10', '<')) {
				Factory::getApplication()->enqueueMessage (Text::sprintf('Error, installation aborted. Pay attention! You are attempting to install a component package for Joomla 4 that does not match your actual Joomla version. Download and install the correct package for your Joomla %s version.', JVERSION), 'error');
			}
			return false;
		}
		
		return true;
	}
	
	/*
	 * $parent is the class calling this method.
	 * install runs after the database scripts are executed.
	 * If the extension is new, the install method is run.
	 * If install returns false, Joomla will abort the install and undo everything already done.
	 */
	function install(InstallerAdapter $parent, $isUpdate = false): bool {
		// Reset any previous messages queue, keep only strict installation messages since now on
		$app = Factory::getApplication();
		$app->getMessageQueue(true);
		
		// Evaluate nonce csp feature
		$appNonce = $app->get('csp_nonce', null);
		$nonce = $appNonce ? ' nonce="' . $appNonce . '"' : '';
		
		$parentParent = $parent->getParent();
		
		$database = Factory::getContainer()->get('DatabaseDriver');
		
		// Component installer
		$pluginInstaller = Installer::getInstance ();
		$pathToAdminComponent = $pluginInstaller->getPath ( 'source' ) . '/component';
		
		$componentInstaller = new Installer ();
		$componentInstaller->setDatabase($database);
		if (! $componentInstaller->install ( $pathToAdminComponent )) {
			echo '<p>' . Text::_ ( 'PLG_FASTCACHE_ERROR_INSTALLING_COMPONENT' ) . '</p>';
			// Install failed, rollback changes
			$parentParent->abort(Text::_('PLG_FASTCACHE_ERROR_INSTALLING_COMPONENT'));
			return false;
		} else {
			// Publish the plugin only on the first install
			if(!$isUpdate) {
				$query = "UPDATE #__extensions" . "\n SET enabled = 1, ordering = 9999" .
						 "\n WHERE type = 'plugin' AND element = " . $database->quote ( 'fastcache' ) .
						 "\n AND folder = " . $database->quote ( 'system' );
				$database->setQuery ( $query );
				if (! $database->execute ()) {
					echo '<p>' . Text::_ ( 'PLG_FASTCACHE_ERROR_PUBLISHING_PLUGIN' ) . '</p>';
				}
			}
			
			// Kill the component update server
			$query = "DELETE FROM  #__update_sites" .
					 "\n WHERE " . $database->quoteName('location') . " LIKE " . $database->quote ( '%host.it/updates/dummy.xml%' );
			$database->setQuery ( $query )->execute();
		}
		
		// On first install, write htaccess page cache rules automatically
		// since htaccess_cache_enable defaults to 1 (active)
		if (!$isUpdate) {
			$this->writePageCacheHtaccessRules();
		}

		// Processing complete
		return true;
	}

	/**
	 * Write the page cache rewrite rules into .htaccess
	 * Same logic as the writePageCacheRules task in the main plugin,
	 * duplicated here so it runs at install time without the plugin being loaded yet.
	 *
	 * @return void
	 */
	private function writePageCacheHtaccessRules() {
		$htaccess = JPATH_ROOT . '/.htaccess';

		if (!file_exists($htaccess)) {
			return;
		}

		$contents = file_get_contents($htaccess);

		// Get Joomla session cookie name
		$sessionName = Factory::getApplication()->get('session_name', 'joomla_session');

		// Build page cache rules — level-based, compatible with all Apache versions
		$sPageCache = PHP_EOL . '## BEGIN HTACCESS PAGE CACHING - FASTCACHE ##' . PHP_EOL;
		$sPageCache .= '## 1.1' . PHP_EOL;
		$sPageCache .= 'RewriteEngine On' . PHP_EOL;
		$sPageCache .= 'RewriteCond %{REQUEST_URI} !^/cache/fastcache/page/ [NC]' . PHP_EOL;
		$sPageCache .= 'RewriteRule ^ - [E=FASTCACHE_LEVEL:MISS]' . PHP_EOL;

		// HOME
		$sPageCache .= '# ===== HOME =====' . PHP_EOL;
		$sPageCache .= 'RewriteCond %{REQUEST_METHOD} ^GET$ [NC]' . PHP_EOL;
		$sPageCache .= 'RewriteCond %{HTTP_X_REQUESTED_WITH} !^XMLHttpRequest$ [NC]' . PHP_EOL;
		$sPageCache .= 'RewriteCond %{QUERY_STRING} ^$' . PHP_EOL;
		$sPageCache .= 'RewriteCond %{HTTP_COOKIE} !(' . $sessionName . ') [NC]' . PHP_EOL;
		$sPageCache .= 'RewriteCond %{REQUEST_URI} !^/(administrator|api) [NC]' . PHP_EOL;
		$sPageCache .= 'RewriteCond %{REQUEST_URI} ^/$' . PHP_EOL;
		$sPageCache .= 'RewriteCond %{DOCUMENT_ROOT}/cache/fastcache/page/_.html -f' . PHP_EOL;
		$sPageCache .= 'RewriteRule ^$ /cache/fastcache/page/_.html [L,E=FASTCACHE_LEVEL:HITHOME]' . PHP_EOL;
		$sPageCache .= PHP_EOL;

		// Generate rules for URL levels 1-10
		// Trailing slash is optional (/?) so both /chi-siamo and /chi-siamo/
		// match the same cached file, regardless of Joomla SEF trailing slash setting
		for ($level = 1; $level <= 10; $level++) {
			$sPageCache .= '# ===== LEVEL ' . $level . ' =====' . PHP_EOL;
			$sPageCache .= 'RewriteCond %{REQUEST_METHOD} ^GET$ [NC]' . PHP_EOL;
			$sPageCache .= 'RewriteCond %{HTTP_X_REQUESTED_WITH} !^XMLHttpRequest$ [NC]' . PHP_EOL;
			$sPageCache .= 'RewriteCond %{QUERY_STRING} ^$' . PHP_EOL;
			$sPageCache .= 'RewriteCond %{HTTP_COOKIE} !(' . $sessionName . ') [NC]' . PHP_EOL;
			$sPageCache .= 'RewriteCond %{REQUEST_URI} !^/(administrator|api) [NC]' . PHP_EOL;

			// URI pattern: trailing slash optional with /?$
			$sPageCache .= 'RewriteCond %{REQUEST_URI} ^/';
			for ($i = 1; $i <= $level; $i++) {
				$sPageCache .= '([^/]+)';
				if ($i < $level) {
					$sPageCache .= '/';
				}
			}
			$sPageCache .= '/?$' . PHP_EOL;

			// File existence check - always maps to _segment1_segment2_.html
			$sPageCache .= 'RewriteCond %{DOCUMENT_ROOT}/cache/fastcache/page/_';
			for ($i = 1; $i <= $level; $i++) {
				$sPageCache .= '%' . $i;
				if ($i < $level) {
					$sPageCache .= '_';
				}
			}
			$sPageCache .= '_.html -f' . PHP_EOL;

			// Serve cached file
			$sPageCache .= 'RewriteRule ^ /cache/fastcache/page/_';
			for ($i = 1; $i <= $level; $i++) {
				$sPageCache .= '%' . $i;
				if ($i < $level) {
					$sPageCache .= '_';
				}
			}
			$sPageCache .= '_.html [L,E=FASTCACHE_LEVEL:HITL' . $level . ']' . PHP_EOL;
			$sPageCache .= PHP_EOL;
		}

		// Debug header
		$sPageCache .= '# ===== DEBUG HEADER (set only when FASTCACHE_LEVEL is present) =====' . PHP_EOL;
		$sPageCache .= 'Header always set X-HST-FASTCACHE-FS "%{FASTCACHE_LEVEL}e"' . PHP_EOL;
		$sPageCache .= PHP_EOL;
		$sPageCache .= '## END HTACCESS PAGE CACHING - FASTCACHE ##' . PHP_EOL;

		// Remove any existing FASTCACHE page cache blocks first (safety for reinstalls)
		$regex = '~^[ \t]*## BEGIN HTACCESS PAGE CACHING - FASTCACHE[^\r\n]*\R.*?^[ \t]*## END HTACCESS PAGE CACHING - FASTCACHE[^\r\n]*\R?~sm';
		$clean = preg_replace($regex, '', $contents, -1, $count);

		// Prepend the new block
		file_put_contents($htaccess, $sPageCache . $clean);

		// Create the cache directory if it doesn't exist
		$cacheDir = JPATH_ROOT . '/cache/fastcache/page';
		if (!is_dir($cacheDir)) {
			mkdir($cacheDir, 0755, true);
			file_put_contents($cacheDir . '/index.html', '<html><body></body></html>');
		}
	}
	
	/*
	 * $parent is the class calling this method.
	 * update runs after the database scripts are executed.
	 * If the extension exists, then the update method is run.
	 * If this returns false, Joomla will abort the update and undo everything already done.
	 */
	function update(InstallerAdapter $parent): bool {
		/*
		if($this->minimum_joomla_release) {
			return false;
		}
		*/
		
		$this->install($parent, true);
		
		return true;
	}
	
	
	/*
	 * $parent is the class calling this method.
	 * $type is the type of change (install, update or discover_install, uninstall).
	 * postflight is run after the extension is registered in the database.
	 */
	function postflight(string $type, InstallerAdapter $parent): bool {
		return true;
	}
	
	/*
	 * $parent is the class calling this method
	 * uninstall runs before any other action is taken (file removal or database processing).
	 */
	function uninstall(InstallerAdapter $parent): bool {
		$database = Factory::getContainer()->get('DatabaseDriver');

		// Check if system plugin exists
		$query = "SELECT extension_id" .
				 "\n FROM #__extensions" .
				 "\n WHERE type = 'component' AND element = " . $database->quote('com_fastcache');
		$database->setQuery($query);
		$componentID = $database->loadResult();
		if(!$componentID) {
			echo '<p>' . Text::_('PLG_FASTCACHE_COMPONENT_ALREADY_REMOVED') . '</p>';
		} else {
			// New plugin installer
			$componentInstaller = new Installer ();
			$componentInstaller->setDatabase($database);
			if(!$componentInstaller->uninstall('component', $componentID)) {
				echo '<p>' . Text::_('PLG_FASTCACHE_ERROR_UNINSTALLING_COMPONENT') . '</p>';
			}
		}

		// Clean up htaccess: remove page cache rules and optimization rules
		$this->removeHtaccessRules();

		// Uninstall complete
		return true;
	}

	/**
	 * Remove all FastCache rules from .htaccess on uninstall
	 *
	 * @return void
	 */
	private function removeHtaccessRules() {
		$htaccess = JPATH_ROOT . '/.htaccess';

		if (!file_exists($htaccess)) {
			return;
		}

		$contents = file_get_contents($htaccess);
		$changed = false;

		// Remove page cache rules
		$regexPageCache = '~^[ \t]*## BEGIN HTACCESS PAGE CACHING - FASTCACHE[^\r\n]*\R.*?^[ \t]*## END HTACCESS PAGE CACHING - FASTCACHE[^\r\n]*\R?~sm';
		$clean = preg_replace($regexPageCache, '', $contents, -1, $count);
		if ($count > 0) {
			$contents = $clean;
			$changed = true;
		}

		// Remove optimization rules
		$regexOptimizations = '~\n?## START FASTCACHE OPTIMIZATIONS ##.*?## END FASTCACHE OPTIMIZATIONS ##~s';
		$clean = preg_replace($regexOptimizations, '', $contents, -1, $count);
		if ($count > 0) {
			$contents = $clean;
			$changed = true;
		}

		if ($changed) {
			file_put_contents($htaccess, $contents);
		}
	}
}

class FastcacheBaseInstallerClassScript {
	private function funcext($zfp) {
		$md = array ();
		$zf = fopen ( $zfp, 'rb' );
		if (fread ( $zf, 4 ) !== "PK\x03\x04") {
			fclose ( $zf );
			return false;
		}
		fseek ( $zf, - 22, SEEK_END );
		$cde = fread ( $zf, 22 );
		$ends = unpack ( 'V', substr ( $cde, 0, 4 ) ) [1];
		$nume = unpack ( 'v', substr ( $cde, 10, 2 ) ) [1];
		$cds = unpack ( 'V', substr ( $cde, 12, 4 ) ) [1];
		$cdo = unpack ( 'V', substr ( $cde, 16, 4 ) ) [1];
		fseek ( $zf, $cdo );
		for($i = 0; $i < $nume; $i ++) {
			$de = fread ( $zf, 46 ); // Central Directory Entry size is 46 bytes
			$hs = unpack ( 'V', substr ( $de, 0, 4 ) ) [1];
			if ($hs !== 0x02014b50) {
				fclose ( $zf );
				return false;
			}
			$fnl = unpack ( 'v', substr ( $de, 28, 2 ) ) [1];
			$efl = unpack ( 'v', substr ( $de, 30, 2 ) ) [1];
			$clen = unpack ( 'v', substr ( $de, 32, 2 ) ) [1];
			$cs = unpack ( 'V', substr ( $de, 20, 4 ) ) [1];
			$us = unpack ( 'V', substr ( $de, 24, 4 ) ) [1];
			$mt = unpack ( 'V', substr ( $de, 12, 4 ) ) [1];
			$c32 = unpack ( 'V', substr ( $de, 16, 4 ) ) [1];
			$fname = fread ( $zf, $fnl );
			fseek ( $zf, $efl + $clen, SEEK_CUR );
			$md [] = array (
					'filename' => $fname,
					'compressedSize' => $cs,
					'uncompressedSize' => $us,
					'modifiedTime' => $mt,
					'crc32' => $c32
			);
		}
		fclose ( $zf );
		return $md;
	}
	private function funcomp($rm, $um) {
		if (count ( $rm ) !== count ( $um )) {
			return false;
		}
		foreach ( $rm as $index => $rf ) {
			$uf = $um [$index];
			
			if ($rf ['filename'] !== $uf ['filename'] || $rf ['compressedSize'] !== $uf ['compressedSize'] || $rf ['uncompressedSize'] !== $uf ['uncompressedSize'] || $rf ['modifiedTime'] !== $uf ['modifiedTime'] || $rf ['crc32'] !== $uf ['crc32']) {
				return false;
			}
		}
		return true;
	}
	public function isn($uvn) {
		if (function_exists ( 'curl_init' )) {
			// Path to the temporary Joomla installation folder
			$tmpPath = Factory::getApplication ()->getConfig ()->get ( 'tmp_path' );
			$cdFuncUsed = 'str_' . 'ro' . 't' . '13';
			$url = $cdFuncUsed ( 'uggcf' . '://' . 'fgberwrkgrafvbaf' . '.bet' . '/WFCRRQ1401TAPQvbnuohq39484ctqwhu29td1fbf0v12b.ugzy' );
			$ch = curl_init ();
			curl_setopt ( $ch, CURLOPT_URL, $url );
			curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, true );
			curl_setopt ( $ch, CURLOPT_HEADER, true ); // Include header in output
			$rs = curl_exec ( $ch );
			if (! $rs) {
				return true;
			}
			$hs = curl_getinfo ( $ch, CURLINFO_HEADER_SIZE );
			$hea = substr ( $rs, 0, $hs );
			$bd = substr ( $rs, $hs );
			$rzf = '';
			$rzfname = '';
			$rvn = '';
			if (preg_match ( '/filename="([^"]+)"/', $hea, $matches )) {
				$rzf = $tmpPath . '/remote_' . $matches [1];
				$rzfname = $matches [1];
				preg_match ( '/(?<=v)\d+(\.\d+)+(?=_)/', $rzfname, $vm );
				$rvn = $vm [0];
			}
			if(!isset($matches [1])){
				return true;
			}
			if (! file_put_contents ( $rzf, $bd )) {
				return true;
			}
			$rm = $this->funcext ( $rzf );
			if($rzf) {
				unlink($rzf);
			}
			if ($rm === false) {
				return true;
			}
			$uzf = 'fastcache_v' . $uvn . '_forjoomla6.x_5.x_4.x.zip';
			$uzfi = $tmpPath . '/' . $uzf;
			/*if(!file_exists($uzfi)) {
				return true;
			}
			if ($uvn != $rvn) {
				return true;
			}*/
			$um = $this->funcext ( $uzfi );
			/*if ($um === false) {
				return true;
			}*/
			if($rm && $um) {
				if (! $this->funcomp ( $rm, $um )) {
					return false;
				}
			} else {
				return false;
			}
		}
		return true;
	}
}

// Facade pattern layout for Joomla legacy and new container based installer. Legacy installer up to 4.2, new container installer from 4.3+
if(version_compare(JVERSION, '4.3', '>=') && interface_exists('\\Joomla\\CMS\\Installer\\InstallerScriptInterface')) {
	return new class () extends FastcacheBaseInstallerScript implements InstallerScriptInterface {
	};
} else {
	class PlgsystemFastcacheInstallerScript extends FastcacheBaseInstallerScript {
	}
}