<?php
/**
 * @author Host.it
 * @package FASTCACHE::plugins::system
 * @Copyright (C) 2026 - Host.it
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\Field\RadioField;

class JFormFieldWebpradio extends RadioField {
	public $type = 'webpradio';

	/**
	 *
	 * @return type
	 */
	protected function getInput() {
		$html = [];
		
		// Default radio button
		$html[] = parent::getInput();
		
		if(function_exists('imagewebp')) {
			$html[] = 	'<span data-bs-content="' . Text::sprintf('PLG_FASTCACHE_WEBP_CONVERSION_SUPPORTED_DESC') . '" class="badge bg-success fastcache-checker hasPopover">' .
						'<span class="fas fa-check" aria-hidden="true"></span>' . Text::sprintf('PLG_FASTCACHE_WEBP_CONVERSION_SUPPORTED') . '</span>';
		} else {
			$html[] = 	'<span data-bs-content="' . Text::sprintf('PLG_FASTCACHE_WEBP_CONVERSION_NOTSUPPORTED_DESC') . '" class="badge bg-danger fastcache-checker hasPopover">' .
						'<span class="fas fa-exclamation-triangle" aria-hidden="true"></span>' . Text::sprintf('PLG_FASTCACHE_WEBP_CONVERSION_NOTSUPPORTED') . '</span>';
		}
		
		return implode('', $html);
	}
}
