<?php
/**
 * @author Host.it
 * @package FASTCACHE::plugins::system
 * @Copyright (C) 2026 - Host.it
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\RangeField;
use Joomla\CMS\Language\Text;

class JFormFieldRangeslider extends RangeField {
	public $type = 'rangeslider';

	/**
	 *
	 * @return type
	 */
	protected function getInput() {
		$doc = Factory::getDocument ();
		
		// Include jQuery/Bootstrap framework
		$wa = $doc->getWebAssetManager();
		$wa->registerAndUseScript ( 'fastcache.autoconfiguration', 'media/plg_fastcache/js/autoconfiguration.js' );
		$wa->registerAndUseStyle ( 'fastcache.autoconfiguration', 'media/plg_fastcache/css/autoconfiguration.css' );
		
		$rangeSlider = '<div id="rangecontainer">';
		$rangeSlider .= parent::getInput ();
		$rangeSlider .= '<div id="rangelabels">' .
							'<span data-container-label="0"><span class="innerlabel" data-label="0">' . Text::_('PLG_FASTCACHE_AUTO_CONFIGURATION_CUSTOM') . '</span></span>' . 
							'<span data-container-label="1"><span class="innerlabel" data-label="1">' . Text::_('PLG_FASTCACHE_AUTO_CONFIGURATION_MINIMUM') . '</span></span>' . 
							'<span data-container-label="2"><span class="innerlabel" data-label="2">' . Text::_('PLG_FASTCACHE_AUTO_CONFIGURATION_STANDARD') . '</span></span>' .
							'<span data-container-label="3"><span class="innerlabel" data-label="3">' . Text::_('PLG_FASTCACHE_AUTO_CONFIGURATION_AVERAGE') . '</span></span>' .
							'<span data-container-label="4"><span class="innerlabel" data-label="4">' . Text::_('PLG_FASTCACHE_AUTO_CONFIGURATION_ADVANCED') . '</span></span>' .
							'<span data-container-label="5"><span class="innerlabel" data-label="5">' . Text::_('PLG_FASTCACHE_AUTO_CONFIGURATION_MAXIMUM') . '</span></span>' .
						'</div>';
		$rangeSlider .= '</div>';
		$rangeSlider .= '<div id="optimizationslist" class="mt-2"></div>';
		
		return $rangeSlider;
	}
}
