<?php
/**
 * @author Host.it
 * @package FASTCACHE::plugins::system
 * @Copyright (C) 2026 - Host.it
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();
use Joomla\CMS\Form\Field\TextField;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

class JFormFieldPagespeedtest extends TextField {
	public $type = 'pagespeedtest';
	
	/**
	 * Inject language constant into JS Domain maintaining same name mapping
	 *
	 * @access protected
	 * @param $translations array
	 * @param $wa Object&
	 * @return void
	 */
	private function injectJsTranslations($translations, $wa): void {
		$jsInject = null;
		// Do translations
		foreach ( $translations as $translation ) {
			$jsTranslation = strtoupper ( $translation );
			$translated = Text::_ ( $jsTranslation, true );
			$jsInject .= <<<JS
							var $translation = '{$translated}';
JS;
		}
		$wa->addInlineScript ( $jsInject );
	}
	
	/**
	 *
	 * @return type
	 */
	protected function getInput() {
		$wa = Factory::getDocument ()->getWebAssetManager();
		
		$this->injectJsTranslations(array(
				'PLG_FASTCACHE_AUTO_CONFIGURATION_MOBILE',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_DESKTOP',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_FCP',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_SI',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_LCP',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_TTI',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_TBT',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_CLS',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_SCREENSHOT',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_MISSINGDATA',
				'PLG_FASTCACHE_AUTO_CONFIGURATION_ERROR_RETRIEVING'
		), $wa);
		
		$wa->registerAndUseStyle ( 'fastcache.pagespeed', 'media/plg_fastcache/css/pagespeed.css' );
		
		$pageSpeedLink = Uri::root(false) . 'administrator/index.php?option=com_ajax&plugin=fastcache&format=json';
		$wa->addInlineScript ( 'var fastcachePageSpeedLink = "' .  $pageSpeedLink . '";' );
		
		$wa->registerAndUseScript ( 'fastcache.progressring', 'media/plg_fastcache/js/progress-ring.js' );
		$wa->registerAndUseScript ( 'fastcache.pagespeed', 'media/plg_fastcache/js/pagespeed.js' );
		
		$btnText = Text::_('PLG_FASTCACHE_AUTO_CONFIGURATION_TEST_BTN');
		$htmlControl = <<<HTMLCONTROL
			<a class="btn btn-sm btn-primary" id="pagespeed-test"><span class="icon-dashboard"></span> $btnText</a>
			<div class="pagespeed-test-url badge bg-light"></div>
			<div class="timeline-container">
				<div class="timeline-wrapper" id="timeline-mobile">
				    <div class="timeline-item">
				        <div class="static-background">
				            <div class="background-masker header-top"></div>
				            <div class="background-masker header-left"></div>
				            <div class="background-masker header-right"></div>
				            <div class="background-masker subheader-left"></div>
				            <div class="background-masker subheader-bottom"></div>
				            <div class="background-masker content-top"></div>
				            <div class="background-masker content-first-end"></div>
				            <div class="background-masker content-second-end"></div>
				            <div class="background-masker content-third-end"></div>
							<div class="background-masker content-forth-line"></div>
							<div class="background-masker content-fifth-line"></div>
				        </div>
				    </div>
				</div>
				<div class="timeline-wrapper" id="timeline-desktop">
				    <div class="timeline-item">
				        <div class="static-background">
				            <div class="background-masker header-top"></div>
				            <div class="background-masker header-left"></div>
				            <div class="background-masker header-right"></div>
				            <div class="background-masker subheader-left"></div>
				            <div class="background-masker subheader-bottom"></div>
				            <div class="background-masker content-top"></div>
				            <div class="background-masker content-first-end"></div>
				            <div class="background-masker content-second-end"></div>
				            <div class="background-masker content-third-end"></div>
							<div class="background-masker content-forth-line"></div>
							<div class="background-masker content-fifth-line"></div>
				        </div>
				    </div>
				</div>
			</div>
HTMLCONTROL;
		
		return $htmlControl;
	}
}
