<?php
/**
 * @author Host.it
 * @package FASTCACHE::plugins::system
 * @Copyright (C) 2026 - Host.it
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\Field\RadioField;

class JFormFieldAvifradio extends RadioField {
	public $type = 'avifradio';

	/**
	 *
	 * @return type
	 */
	protected function getInput() {
		$html = [];
		
		// Default radio button
		$html[] = parent::getInput();
		
		if(version_compare(PHP_VERSION, '8.1', '>=') && function_exists('imageavif')) {
			// Convert a dummy image to check if the size is > 0 bytes
			$imageFileSize = 0;
			$mediaFilePath = JPATH_ROOT . '/media/plg_fastcache/images/';
			$convertedImage = $mediaFilePath . 'output.avif';
			if(!file_exists($convertedImage)) {
				$originalImage = imagecreatefrompng($mediaFilePath . 'fastcache_logo.png');
				// Ensure a valid GDImage is available
				if($originalImage) {
					$result = imageavif($originalImage, $convertedImage);
					if($result) {
						$imageFileSize = filesize($convertedImage);
					}
				} else {
					$imageFileSize = 0;
				}
			} else {
				$imageFileSize = filesize($convertedImage);
			}
			
			if($imageFileSize > 0) {
				$html[] = 	'<span data-bs-content="' . Text::sprintf('PLG_FASTCACHE_AVIF_CONVERSION_SUPPORTED_DESC') . '" class="badge bg-success fastcache-checker hasPopover">' .
							'<span class="fas fa-check" aria-hidden="true"></span>' . Text::sprintf('PLG_FASTCACHE_AVIF_CONVERSION_SUPPORTED') . '</span>';
			} else {
				$html[] = 	'<span data-bs-content="' . Text::sprintf('PLG_FASTCACHE_AVIF_CONVERSION_NOTSUPPORTED_DESC') . '" class="badge bg-danger fastcache-checker hasPopover">' .
							'<span class="fas fa-exclamation-triangle" aria-hidden="true"></span>' . Text::sprintf('PLG_FASTCACHE_AVIF_CONVERSION_NOTSUPPORTED') . '</span>';
			}
		} else {
			$html[] = 	'<span data-bs-content="' . Text::sprintf('PLG_FASTCACHE_AVIF_CONVERSION_NOTSUPPORTED_DESC') . '" class="badge bg-danger fastcache-checker hasPopover">' .
						'<span class="fas fa-exclamation-triangle" aria-hidden="true"></span>' . Text::sprintf('PLG_FASTCACHE_AVIF_CONVERSION_NOTSUPPORTED') . '</span>';
		}
		
		return implode('', $html);
	}
}
