<?php
/**
 * @author Host.it
 * @package FASTCACHE::plugins::system
 * @Copyright (C) 2026 - Host.it
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();
use Joomla\CMS\Factory;
use Fastcache\Admin;
use Fastcache\Html;
use Fastcache\Plugin;
use Fastcache\Ajax;
use Fastcache\Settings;
use Fastcache\Utilities;
use Fastcache\JsonManager;

include_once JPATH_PLUGINS . '/system/fastcache/Framework/loader.php';

if (! defined ( 'FASTCACHE_VERSION' )) {
	$currentVersion = strval ( simplexml_load_file ( JPATH_ROOT . '/plugins/system/fastcache/fastcache.xml' )->version );
	define ( 'FASTCACHE_VERSION', $currentVersion );
}

$app = Factory::getApplication ();

$action = $app->getInput()->get ( 'task', '', 'string' );

if (! $action) {
	exit ();
}

try {
	$results = FastcacheAjaxHelper::$action ();
} catch ( \Exception $e ) {
	$results = $e;
}

if (is_scalar ( $results ) || is_object ( $results )) {
	$out = ( string ) $results;
} else {
	$out = implode ( ( array ) $results );
}

echo $out;
class FastcacheAjaxHelper {
	/**
	 */
	public static function garbagecron() {
		return Ajax::garbageCron ( Settings::getInstance ( $this->params ) );
	}

	/**
	 */
	public static function exclusionfiles() {
		$aData = Utilities::get ( 'data', '', 'array' );

		$params = Plugin::getPluginParams ();
		$oAdmin = new Admin ( $params, true );
		$oHtml = new Html ( $params );

		try {
			$sHtml = $oHtml->getOriginalHtml ();
			$oAdmin->getAdminLinks ( $sHtml );
		} catch ( \Exception $e ) {
		}

		$response = array ();

		if(!empty($aData)) {
			foreach ( $aData as $sData ) {
				$options = $oAdmin->prepareFieldOptions ( $sData ['type'], $sData ['param'], $sData ['group'], false );
				$response [$sData ['id']] = new JsonManager ( $options );
			}
		}
		
		return new JsonManager ( $response );
	}
}

jexit ();
