<?php
/**
 * @author Host.it
 * @package FASTCACHE::plugins::system
 * @Copyright (C) 2026 - Host.it
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
function FastcacheAutoLoader($sClass) {
	if (is_array ( $sClass )) {
		foreach ( $sClass as $class ) {
			FastcacheAutoLoader( $class );
		}
	} else {
		$class = $sClass;
	}

	$prefix = substr ( $class, 0, 10 );

	// If the class already exists do nothing.
	if (class_exists ( $class, false )) {
		return true;
	}

	if ($prefix !== 'Fastcache\\') {
		return false;
	} else {
		$class = str_replace ( $prefix, '', $class );
	}

	$class = trim($class, '\\');
	
	$filename = $class;
	$file = dirname ( __FILE__ ) . '/' . $filename . '.php';

	if (! file_exists ( $file )) {
		return false;
	} else {
		include $file;

		if (! class_exists ( $sClass ) && ! interface_exists ( $sClass )) {
			return false;
		}
	}
}

spl_autoload_register ( 'FastcacheAutoLoader', true, true );